function isEmailAddr(email)
{
  var result = false;
  var theStr = new String(email);
  var index = theStr.indexOf("@");
  if (index > 0)
  {
    var pindex = theStr.indexOf(".",index);
    if ((pindex > index+1) && (theStr.length > pindex+1))
		result = true;
  }
  return result;
}

function validRequired(formField,fieldLabel)
{
	var result = true;
	
	if (formField.value == "")
	{
		alert('Please enter ' + fieldLabel +' .');
		formField.focus();
		result = false;
	}
	
	return result;
}

function allDigits(str)
{
	return inValidCharSet(str,"0123456789.");
}

function inValidCharSet(str,charset)
{
	var result = true;

	// Note: doesn't use regular expressions to avoid early Mac browser bugs
	for (var i=0;i<str.length;i++)
		if (charset.indexOf(str.substr(i,1))<0)
		{
			result = false;
			break;
		}
	return result;
}
function validEmail(formField,fieldLabel,required)
{
	var result = true;
	if (required && !validRequired(formField,fieldLabel))
		result = false;
	if (result && ((formField.value.length < 3) || !isEmailAddr(formField.value)) )
	{
		alert("Please enter your Email");
		formField.focus();
		result = false;
	}
  return result;
}

function validPassword(formField,fieldLabel,required)
{
	var result = true;
	if (required && !validRequired(formField,fieldLabel))
		result = false;
	if (result && ((formField.value.length < 5)) )
	{
		alert("Your \'" + fieldLabel + "\' must be equal or greater than 5 digits");
		formField.focus();
		result = false;
	}
  return result;
}

function chkPassword(formField1,formField2,required)
{
	var result = true;
	if (result && ((formField1.value!=formField2.value)))
	{
		alert("Your both passwords do not match");
		formField1.focus();
		result = false;
	}
  return result;
}

function validNum(formField,fieldLabel,required)
{
	var result = true;

	if (required && !validRequired(formField,fieldLabel))
		result = false;
  
 	if (result)
 	{
 		if (!allDigits(formField.value))
 		{
 			alert('Please enter a number for the "' + fieldLabel +'" field.');
			formField.focus();		
			result = false;
		}
	} 
	
	return result;
}

function validInt(formField,fieldLabel,required)
{
	var result = true;

	if (required && !validRequired(formField,fieldLabel))
		result = false;
  
 	if (result)
 	{
 		var num = parseInt(formField.value,10);
 		if (isNaN(num))
 		{
 			alert('Please enter a number for the "' + fieldLabel +'" field.');
			formField.focus();		
			result = false;
		}
	} 
	
	return result;
}